/*
  A line between two points.
*/
module Line(P1,P2,Thickness=0.05,2D=false){
    if(2D&&(len(P1)==2)){
        Position(P2-P1,Base=P1)
        translate([-Smidge,-Thickness/2,0])
        cube([Smidge,Thickness,Modulus(P2-P1)]);
    }else{
        CylinderBetween(
            P1,P2,Thickness/2
            // Use $fc--if set--to construct the curve, i.e., for the curve's elements, or the 'default' number of segments otherwise.
            ,$fn=$fc==0
            ?   Segments(Radius,$fn=0) // $fn=0 here 'disables' $fn in Segments().
            :   $fc
        );
    }
}

