/*
  Tries to find the first tangent-point on a curve, for line originating from a given vertex.

  Compares vector-angle of curve-vertex to given vertex for successive curve vertices. When the angular _trend_ switches, we have a tangent (well, something close to it at least).
*/
/* TODO: Make this work in 3D? */
function TangentPoint(Vertex,Curve,Direction=1,Index)=
    let(
        $Len=Len(Curve),
        $Array=Curve
    )
    /* Prime and call the relevant iterator. */
    Direction>0
    ?   _UpTangentPoint(Vertex,Index==undef?1:max(Index,1))
    :   _DownTangentPoint(Vertex,Index==undef?$Len-1:min(Index,$Len-1))
;


function _UpTangentPoint(Vertex,Index)=
    Index>$Len-1
    ?   undef /* No tangent point on *Curve*. */
    :   let(
            Current=$Array[Index],
            /* Angle between Vertex-Current 'radial' and positive X-axis. */
            Rot=atan2(Current.y-Vertex.y,Current.x-Vertex.x),
            /* Rotate Previous, Current, and Next curve vertex so Current lies on the positive X-axis. */
            Triplet=AffineRotate([0,0,-Rot],[$Array[Index-1],Current,$Array[Index+1]],Output2D=true),
            /* Name the new vertices. */
            PV=Triplet[0],
            CV=Triplet[1],
            NV=Triplet[2],
            /* If PV-CV has a negative slope, and CV-NV has a positive slope, we have a tangent point. Idem ditto for the converse. If both slopes are either positive or negative, the 'radial' crosses *Curve*, and Current is no tangent point. Therefore, if the product of the slopes is negative, we have a tangent point.*/
            Ext=atan2(CV.y-PV.y,CV.x-PV.x)*atan2(NV.y-CV.y,NV.x-CV.x)<0
        )
    Ext /* Do we have a tangent point? */
    ?   Index /* Yay. */
    :   _UpTangentPoint(Vertex,Index+1) /* Try again. */
;

function _DownTangentPoint(Vertex,Index)=
    Index<1
    ?   undef /* No tangent point on *Curve*. */
    :   let(
            Current=$Array[Index],
            /* Angle between Vertex-Current 'radial' and positive X-axis. */
            Rot=atan2(Current.y-Vertex.y,Current.x-Vertex.x),
            /* Rotate Previous, Current, and Next curve vertex so Current lies on the positive X-axis. */
            Triplet=AffineRotate([0,0,-Rot],[$Array[Index-1],Current,$Array[Index+1]],Output2D=true),
            /* Name the new vertices. */
            PV=Triplet[0],
            CV=Triplet[1],
            NV=Triplet[2],
            /* If PV-CV has a negative slope, and CV-NV has a positive slope, we have a tangent point. Idem ditto for the converse. If both slopes are either positive or negative, the 'radial' from *Vertex* crosses *Curve*, and Current is no tangent point. Therefore, if the product of the slopes is negative, we have a tangent point.*/
            Ext=atan2(CV.y-PV.y,CV.x-PV.x)*atan2(NV.y-CV.y,NV.x-CV.x)<0
        )
    Ext /* Do we have a tangent point? */
    ?   Index /* Yay. */
    :   _DownTangentPoint(Vertex,Index-1) /* Try again. */
;
