/*
  A vertical line at X=...
*/
module VLine(X,Thickness=0.05,2D=false){
    if(2D){
        translate([X-Thickness/2,-5000,-Smidge])
        cube([Thickness,10000,Smidge]);
    }else{
        translate([X,-5000,0])
        CylinderBetween(
            [0,-5000,0],[0,5000,0],Thickness/2
            // Use $fc--if set--to construct the curve, i.e., for the curve's elements, or the 'default' number of segments otherwise.
            ,$fn=$fc==0
            ?   Segments(Radius,$fn=0) // $fn=0 here 'disables' $fn in Segments().
            :   $fc
        );
    }

}

