/*
  This file contains the lookup list for Braille dot-patterns for _most_ characters.

  The GHOUL tries to adhere to and parse Unified English Braille.
*/

/* Some standard dimensions, used by BrailleText.scad. */
/* These Imperial dimensions work nicely... */
/*
BrailleDotHeight=0.635; // 25 Thou in mm.
BrailleDotRadius=0.762; // 30 Thou in mm.
BrailleDotSpacing=2.54; // 100 Thou in mm.
BrailleCellSpacing=6.35; // 250 Thou in mm.
BrailleLineHeight=10.16; // 400 Thou in mm.
*/
/*
  Canadian and European standards mostly agree, and these are values that logically form when you have a look at the allowable ranges of the individual dimensions. American standards--surprisingly--seem to run a little bit smaller, but this is still very close.
*/
BrailleDotHeight=0.8; // mm.
BrailleDotRadius=0.8; // mm.
BrailleDotSpacing=2.5; // mm.
BrailleCellSpacing=7; // mm.
BrailleLineHeight=10; // mm.

/*
  Braille DotPatterns.

  Braille pattern dot numbers (notice funky 7 and 8 locations; this is because in original Braille, there were only 6 dots...)
  1 4
  2 5
  3 6
  7 8

  Dotpattern in vectors (basically the two columns)
  [[1,2,3,7],[4,5,6,8]]

  Reverse binary (simply in order)
  "12345678"

*/
/*
    Mostly Ascii, some extended, printable symbols and their Braille patterns.

    This list is (very) incomplete, but allows us to parse some basic Braille for simple signage &c. The routines in The GHOUL do NOT purport to be anything but the most basic, and I don't have aspirations to write a complete Braille parser. If you fancy improving on what's here and in BrailleText.scad, please keep me posted and share your work so I can share it with the world.

    EMAIL: theghoul@hankjr.ca

    [ Symbol ,Decimal UCode ,DotPattern ]
*/
BrailleNumerics=".,0123456789";
BrailleCurrency=" $£€";
BraillePatterns=[
     /* Space. */
     [" "  , 32 ,[[[0,0,0,0],[0,0,0,0]]]]
     /* Uppercase. */
    ,["A"  ,65   ,[[[1,0,0,0],[0,0,0,0]]]]
    ,["B"  ,66   ,[[[1,1,0,0],[0,0,0,0]]]]
    ,["C"  ,67   ,[[[1,0,0,0],[1,0,0,0]]]]
    ,["D"  ,68   ,[[[1,0,0,0],[1,1,0,0]]]]
    ,["E"  ,69   ,[[[1,0,0,0],[0,1,0,0]]]]
    ,["F"  ,70   ,[[[1,1,0,0],[1,0,0,0]]]]
    ,["G"  ,71   ,[[[1,1,0,0],[1,1,0,0]]]]
    ,["H"  ,72   ,[[[1,1,0,0],[0,1,0,0]]]]
    ,["I"  ,73   ,[[[0,1,0,0],[1,0,0,0]]]]
    ,["J"  ,74   ,[[[0,1,0,0],[1,1,0,0]]]]
    ,["K"  ,75   ,[[[1,0,1,0],[0,0,0,0]]]]
    ,["L"  ,76   ,[[[1,1,1,0],[0,0,0,0]]]]
    ,["M"  ,77   ,[[[1,0,1,0],[1,0,0,0]]]]
    ,["N"  ,78   ,[[[1,0,1,0],[1,1,0,0]]]]
    ,["O"  ,79   ,[[[1,0,1,0],[0,1,0,0]]]]
    ,["P"  ,80   ,[[[1,1,1,0],[1,0,0,0]]]]
    ,["Q"  ,81   ,[[[1,1,1,0],[1,1,0,0]]]]
    ,["R"  ,82   ,[[[1,1,1,0],[0,1,0,0]]]]
    ,["S"  ,83   ,[[[0,1,1,0],[1,0,0,0]]]]
    ,["T"  ,84   ,[[[0,1,1,0],[1,1,0,0]]]]
    ,["U"  ,85   ,[[[1,0,1,0],[0,0,1,0]]]]
    ,["V"  ,86   ,[[[1,1,1,0],[0,0,1,0]]]]
    ,["W"  ,87   ,[[[0,1,0,0],[1,1,1,0]]]]
    ,["X"  ,88   ,[[[1,0,1,0],[1,0,1,0]]]]
    ,["Y"  ,89   ,[[[1,0,1,0],[1,1,1,0]]]]
    ,["Z"  ,90   ,[[[1,0,1,0],[0,1,1,0]]]]
     /* Lowercase. */
    ,["a"  ,97   ,[[[1,0,0,0],[0,0,0,0]]]]
    ,["b"  ,98   ,[[[1,1,0,0],[0,0,0,0]]]]
    ,["c"  ,99   ,[[[1,0,0,0],[1,0,0,0]]]]
    ,["d"  ,100  ,[[[1,0,0,0],[1,1,0,0]]]]
    ,["e"  ,101  ,[[[1,0,0,0],[0,1,0,0]]]]
    ,["f"  ,102  ,[[[1,1,0,0],[1,0,0,0]]]]
    ,["g"  ,103  ,[[[1,1,0,0],[1,1,0,0]]]]
    ,["h"  ,104  ,[[[1,1,0,0],[0,1,0,0]]]]
    ,["i"  ,105  ,[[[0,1,0,0],[1,0,0,0]]]]
    ,["j"  ,106  ,[[[0,1,0,0],[1,1,0,0]]]]
    ,["k"  ,107  ,[[[1,0,1,0],[0,0,0,0]]]]
    ,["l"  ,108  ,[[[1,1,1,0],[0,0,0,0]]]]
    ,["m"  ,109  ,[[[1,0,1,0],[1,0,0,0]]]]
    ,["n"  ,110  ,[[[1,0,1,0],[1,1,0,0]]]]
    ,["o"  ,111  ,[[[1,0,1,0],[0,1,0,0]]]]
    ,["p"  ,112  ,[[[1,1,1,0],[1,0,0,0]]]]
    ,["q"  ,113  ,[[[1,1,1,0],[1,1,0,0]]]]
    ,["r"  ,114  ,[[[1,1,1,0],[0,1,0,0]]]]
    ,["s"  ,115  ,[[[0,1,1,0],[1,0,0,0]]]]
    ,["t"  ,116  ,[[[0,1,1,0],[1,1,0,0]]]]
    ,["u"  ,117  ,[[[1,0,1,0],[0,0,1,0]]]]
    ,["v"  ,118  ,[[[1,1,1,0],[0,0,1,0]]]]
    ,["w"  ,119  ,[[[0,1,0,0],[1,1,1,0]]]]
    ,["x"  ,120  ,[[[1,0,1,0],[1,0,1,0]]]]
    ,["y"  ,121  ,[[[1,0,1,0],[1,1,1,0]]]]
    ,["z"  ,122  ,[[[1,0,1,0],[0,1,1,0]]]]
     /* Numbers. */
    ,["0"  ,48   ,[[[0,1,0,0],[1,1,0,0]]]]
    ,["1"  ,49   ,[[[1,0,0,0],[0,0,0,0]]]]
    ,["2"  ,50   ,[[[1,1,0,0],[0,0,0,0]]]]
    ,["3"  ,51   ,[[[1,0,0,0],[1,0,0,0]]]]
    ,["4"  ,52   ,[[[1,0,0,0],[1,1,0,0]]]]
    ,["5"  ,53   ,[[[1,0,0,0],[0,1,0,0]]]]
    ,["6"  ,54   ,[[[1,1,0,0],[1,0,0,0]]]]
    ,["7"  ,55   ,[[[1,1,0,0],[1,1,0,0]]]]
    ,["8"  ,56   ,[[[1,1,0,0],[0,1,0,0]]]]
    ,["9"  ,57   ,[[[0,1,0,0],[1,0,0,0]]]]
     /* Punctuation-basic. */
    ,["!"  ,33   ,[[[0,1,1,0],[0,1,0,0]]]]
    ,["&"  ,38   ,[[[1,1,1,0],[1,0,1,0]]]]
    ,["'"  ,39   ,[[[0,0,1,0],[0,0,0,0]]]]
    ,[","  ,44   ,[[[0,1,0,0],[0,0,0,0]]]]
    ,["-"  ,45   ,[[[0,0,1,0],[0,0,1,0]]]]
    ,["."  ,46   ,[[[0,1,0,0],[0,1,1,0]]]]
    ,[":"  ,58   ,[[[0,1,0,0],[0,1,0,0]]]]
    ,[";"  ,59   ,[[[0,1,1,0],[0,0,0,0]]]]
    ,["?"  ,63   ,[[[0,1,1,0],[0,0,1,0]]]]
     /* Compound symbols. */
    ,["\"" ,34   ,[[[0,0,0,0],[0,0,1,0]],[[0,1,1,0],[0,1,1,0]]]]
    ,["#"  ,35   ,[[[0,0,0,0],[1,1,1,0]],[[1,0,0,0],[1,1,1,0]]]]
    ,["$"  ,36   ,[[[0,0,0,0],[1,0,0,0]],[[0,1,1,0],[1,0,0,0]]]]
    ,["%"  ,37   ,[[[0,0,0,0],[1,0,1,0]],[[0,0,1,0],[0,1,1,0]]]]
    ,["("  ,40   ,[[[0,0,0,0],[0,1,0,0]],[[1,1,0,0],[0,0,1,0]]]]
    ,[")"  ,41   ,[[[0,0,0,0],[0,1,0,0]],[[0,0,1,0],[1,1,0,0]]]]
    ,["*"  ,42   ,[[[0,0,0,0],[0,1,0,0]],[[0,0,1,0],[0,1,0,0]]]]
    ,["+"  ,43   ,[[[0,0,0,0],[0,1,0,0]],[[0,1,1,0],[0,1,0,0]]]]
    ,["/"  ,47   ,[[[0,0,0,0],[1,1,1,0]],[[0,0,1,0],[1,0,0,0]]]]
    ,["<"  ,60   ,[[[0,0,0,0],[1,0,0,0]],[[1,1,0,0],[0,0,1,0]]]]
    ,["="  ,61   ,[[[0,0,0,0],[0,1,0,0]],[[0,1,1,0],[0,1,1,0]]]]
    ,[">"  ,62   ,[[[0,0,0,0],[1,0,0,0]],[[0,0,1,0],[1,1,0,0]]]]
    ,["@"  ,64   ,[[[0,0,0,0],[1,0,0,0]],[[1,0,0,0],[0,0,0,0]]]]
    ,["["  ,91   ,[[[0,0,0,0],[1,0,1,0]],[[1,1,0,0],[0,0,1,0]]]]
    ,["\\" ,92   ,[[[0,0,0,0],[1,1,1,0]],[[1,0,0,0],[0,0,1,0]]]]
    ,["]"  ,93   ,[[[0,0,0,0],[1,0,1,0]],[[0,0,1,0],[1,1,0,0]]]]
    ,["_"  ,95   ,[[[0,0,0,0],[1,0,1,0]],[[0,0,1,0],[0,0,1,0]]]]
    ,["£"  ,163  ,[[[0,0,0,0],[1,0,0,0]],[[1,1,1,0],[0,0,0,0]]]]
    ,["°"  ,176  ,[[[0,0,0,0],[1,1,0,0]],[[0,1,0,0],[1,1,0,0]]]]
    ,["€"  ,8364 ,[[[0,0,0,0],[1,0,0,0]],[[1,0,0,0],[0,1,0,0]]]]
    /* Indicators. */
    ,["NumericIndicator"   ,0    ,[[[0,0,1,0],[1,1,1,0]]]]
    ,["DotSix"             ,0    ,[[[0,0,0,0],[0,0,1,0]]]]
     /* Empty lines. */
    ,[""                   ,0    ,[[[0,0,0,0],[0,0,0,0]]]]
    ,[""                   ,0    ,[[[0,0,0,0],[0,0,0,0]],[[0,0,0,0],[0,0,0,0]]]]
    /* Lowercase has identical DotPattern to uppercase. */
];


