/* No longer truly required now that PI is defined in OpenSCAD, but left here for convenience. */
//Pi=3.1415926535897932384626433832795028841971693993751058209;
Pi=PI;
/* Like Pi but much more better... */
Tau=PI*2;

/* Rows 0 through 10 of Pascal's triangle. Binomial Coefficients. */
BiCos=
    [
        [1],
        [1, 1],
        [1, 2, 1],
        [1, 3, 3, 1],
        [1, 4, 6, 4, 1],
        [1, 5, 10, 10, 5, 1],
        [1, 6, 15, 20, 15, 6, 1],
        [1, 7, 21, 35, 35, 21, 7, 1],
        [1, 8, 28, 56, 70, 56, 28, 8, 1],
        [1, 9, 36, 84, 126, 126, 84, 36, 9, 1],
        [1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1]
    ]
;

/* A small dimension. */
Tad=1/64; // (2^6)
/* A smaller but -still- significant dimension. */
Smidge=1/256; // (2^8)
/* A really small dimension. */
Hint=1/1024; // (2^10)
/* Barely anything at all. */
Thought=1/4096; // (2^12)
/* Fine. Very fine. So fine, you can't even see it. */
FrogsHair=1/16384; // (2^14)
/* About the smallest sensible number you might ever need... Maybe. */
One64K=1/65536; // (2^16) Reminds me of my Commodore 64...

C64=65536;
Lots=1e10;

/* For overlap/oversize of cutting bodies; add 'Cut' and move by 'HalfCut' to center the body. */
Cut=0.1;
HalfCut=Cut/2;
/* A dinky cut just to make things look good in demo files and such... */
ViewCut=Tad;

Digits="0123456789";

NumericCharacters="-.0123456789";
NumericValues=[[0],[0],[0],[1],[2],[3],[4],[5],[6],[7],[8],[9]];

HexCharacters="0123456789ABCDEF";
HexCharLow="0123456789AaBbCcDdEeFf";
HexValues=[0,1,2,3,4,5,6,7,8,9,10,10,11,11,12,12,13,13,14,14,15,15];

UpperCase="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
LowerCase="abcdefghijklmnopqrstuvwxyz";

/* Used by some text functions. 'Space' is the first character, only " and \ are escaped and appear as '\"' and '\\' */
PrintableCharacters=" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
PrintableCodes=[for(Index=[32:126]) Index];

/* Used by some text functions. Includes 'TAB', 'NEWLINE' and 'RETURN' besides the printable characters (see above) */
AsciiCharacters = "\t\n\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
AsciiCodes=concat(9,10,13,[for(Index=[32:126]) Index]);

/* Calculated values, using functions depending on definitions above. */
UniCodes=[for(Item=AsciiCodes)Prefix(DecToHex(Item))];

DigitsAscii=AsciiMapString(Digits);
NumericAscii=AsciiMapString(NumericCharacters);

/* SVG constants. */
SVGCommands="AaCcHhLlMmQqSsTtVv"; // Zz are nonsense for us
SVGCommandsPlus="AaBbCcFfHhLlMmQqSsTtVv"; // Zz are nonsense for us
SVGPlusAscii=AsciiMapString(SVGCommandsPlus);

/* TODO <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
/* Tracking and kerning values. This will change with proper kerning and the SVG library. Soon. Maybe. */
MonoTrack=FillTuple(95,1);
MonoKern=FillTuple(95,0.5);

WeekDays=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
WeekDays3Char=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
WeekDays1Char=["S","M","T","W","T","F","S"];
Months=["January","February","March","April","May","June","July","August","September","October","November","December"];
MonthDays=[31,28,31,30,31,30,31,31,30,31,30,31];

