/*
  This file contains the lookup list for Braille dot-patterns for _most_ characters.
*/

/* Some standard dimensions. */
/*
BrailleDotHeight=0.635; // 25 Thou in mm.
BrailleDotRadius=0.762; // 30 Thou in mm.
BrailleDotSpacing=2.54; // 100 Thou in mm.
BrailleCellSpacing=6.35; // 250 Thou in mm.
BrailleLineHeight=10.16; // 400 Thou in mm.
*/
/* Canadian and European standards mostly agree, and these are values that logically form when you have a look at the allowable ranges of the individual dimensions. American standards--surprisingly--seem to run a little bit smaller, but this is still very close. */
BrailleDotHeight=0.8; // mm.
BrailleDotRadius=0.8; // mm.
BrailleDotSpacing=2.5; // mm.
BrailleCellSpacing=7; // mm.
BrailleLineHeight=10; // mm.

/*
  Braille DotPatterns.

  Braille pattern dot numbers (notice funky 7 and 8 locations; this is because in original Braille, there were only 6 dots...)
  1 4
  2 5
  3 6
  7 8

  Dotpattern in vectors (basically the two columns)
  [[1,2,3,7],[4,5,6,8]]

  Reverse binary (simply in order)
  "12345678"

*/
BraillePatterns=
    [    /*  [ Ascii ,Symbol ,Meaning ,DotPattern ,ReverseBinary+64+128 ]  */
         /* DotPattern and ReverseBinary+64+128 have provision for 8-cell. */
         [  0 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  1 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  2 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  3 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  4 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  5 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  6 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  7 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  8 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[  9 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 10 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 11 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 12 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 13 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 14 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 15 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 16 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 17 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 18 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 19 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 20 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 21 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 22 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 23 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 24 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 25 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 26 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 27 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 28 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 29 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 30 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 31 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 32 ," "  ,"Space"              ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        ,[ 33 ,"!"  ,"the"                ,[[0,1,1,0],[1,0,1,0]] ,"01110100"]
        ,[ 34 ,"\"" ,"(contraction)"      ,[[0,0,0,0],[0,1,0,0]] ,"00001000"]
        ,[ 35 ,"#"  ,"(number prefix)"    ,[[0,0,1,0],[1,1,1,0]] ,"00111100"]
        ,[ 36 ,"$"  ,"ed"                 ,[[1,1,0,0],[1,0,1,0]] ,"11010100"]
        ,[ 37 ,"%"  ,"sh"                 ,[[1,0,0,0],[1,0,1,0]] ,"10010100"]
        ,[ 38 ,"&"  ,"and"                ,[[1,1,1,0],[1,0,1,0]] ,"11110100"]
        ,[ 39 ,"'"  ,"'"                  ,[[0,0,1,0],[0,0,0,0]] ,"00100000"]
        ,[ 40 ,"("  ,"of"                 ,[[1,1,1,0],[0,1,1,0]] ,"11101100"]
        ,[ 41 ,")"  ,"with"               ,[[0,1,1,0],[1,1,1,0]] ,"01111100"]
        ,[ 42 ,"*"  ,"ch"                 ,[[1,0,0,0],[0,0,1,0]] ,"10000100"]
        ,[ 43 ,"+"  ,"ing"                ,[[0,0,1,0],[1,0,1,0]] ,"00110100"]
        ,[ 44 ,","  ,"(uppercase prefix)" ,[[0,0,0,0],[0,0,1,0]] ,"00000100"]
        ,[ 45 ,"-"  ,"-"                  ,[[0,0,1,0],[0,0,1,0]] ,"00100100"]
        ,[ 46 ,"."  ,"(italic prefix)"    ,[[0,0,0,0],[1,0,1,0]] ,"00010100"]
        ,[ 47 ,"/"  ,"st"                 ,[[0,0,1,0],[1,0,0,0]] ,"00110000"]
        ,[ 48 ,"0"  ,"\""                 ,[[0,0,1,0],[0,1,1,0]] ,"00101100"]
        ,[ 49 ,"1"  ,","                  ,[[0,1,0,0],[0,0,0,0]] ,"01000000"]
        ,[ 50 ,"2"  ,";"                  ,[[0,1,1,0],[0,0,0,0]] ,"01100000"]
        ,[ 51 ,"3"  ,":"                  ,[[0,1,0,0],[0,1,0,0]] ,"01001000"]
        ,[ 52 ,"4"  ,"."                  ,[[0,1,0,0],[0,1,1,0]] ,"01001100"]
        ,[ 53 ,"5"  ,"en"                 ,[[0,1,0,0],[0,0,1,0]] ,"01000100"]
        ,[ 54 ,"6"  ,"!"                  ,[[0,1,1,0],[0,1,0,0]] ,"01101000"]
        ,[ 55 ,"7"  ,"( or )"             ,[[0,1,1,0],[0,1,1,0]] ,"01101100"]
        ,[ 56 ,"8"  ,"\" or ?"            ,[[0,1,1,0],[0,0,1,0]] ,"01100100"]
        ,[ 57 ,"9"  ,"in"                 ,[[0,0,1,0],[0,1,0,0]] ,"00101000"]
        ,[ 58 ,":"  ,"wh"                 ,[[1,0,0,0],[0,1,1,0]] ,"10001100"]
        ,[ 59 ,";"  ,"(letter prefix)"    ,[[0,0,1,0],[0,1,1,0]] ,"00101100"]
        ,[ 60 ,"<"  ,"gh"                 ,[[1,1,0,0],[0,0,1,0]] ,"11000100"]
        ,[ 61 ,"="  ,"for"                ,[[1,1,1,0],[1,1,1,0]] ,"11111100"]
        ,[ 62 ,">"  ,"ar"                 ,[[0,0,1,0],[1,1,0,0]] ,"00111000"]
        ,[ 63 ,"?"  ,"th"                 ,[[1,0,0,0],[1,1,1,0]] ,"10011100"]
        ,[ 64 ,"@"  ,"(accent prefix)"    ,[[0,0,0,0],[1,0,0,0]] ,"00010000"]
        ,[ 65 ,"A"  ,"a"                  ,[[1,0,0,0],[0,0,0,0]] ,"10000000"]
        ,[ 66 ,"B"  ,"b"                  ,[[1,1,0,0],[0,0,0,0]] ,"11000000"]
        ,[ 67 ,"C"  ,"c"                  ,[[1,0,0,0],[1,0,0,0]] ,"10010000"]
        ,[ 68 ,"D"  ,"d"                  ,[[1,0,0,0],[1,1,0,0]] ,"10011000"]
        ,[ 69 ,"E"  ,"e"                  ,[[1,0,0,0],[0,1,0,0]] ,"10001000"]
        ,[ 70 ,"F"  ,"f"                  ,[[1,1,0,0],[1,0,0,0]] ,"11010000"]
        ,[ 71 ,"G"  ,"g"                  ,[[1,1,0,0],[1,1,0,0]] ,"11011000"]
        ,[ 72 ,"H"  ,"h"                  ,[[1,1,0,0],[0,1,0,0]] ,"11001000"]
        ,[ 73 ,"I"  ,"i"                  ,[[0,1,0,0],[1,0,0,0]] ,"01010000"]
        ,[ 74 ,"J"  ,"j"                  ,[[0,1,0,0],[1,1,0,0]] ,"01011000"]
        ,[ 75 ,"K"  ,"k"                  ,[[1,0,1,0],[0,0,0,0]] ,"10100000"]
        ,[ 76 ,"L"  ,"l"                  ,[[1,1,1,0],[0,0,0,0]] ,"11100000"]
        ,[ 77 ,"M"  ,"m"                  ,[[1,0,1,0],[1,0,0,0]] ,"10110000"]
        ,[ 78 ,"N"  ,"n"                  ,[[1,0,1,0],[1,1,0,0]] ,"10111000"]
        ,[ 79 ,"O"  ,"o"                  ,[[1,0,1,0],[0,1,0,0]] ,"10101000"]
        ,[ 80 ,"P"  ,"p"                  ,[[1,1,1,0],[1,0,0,0]] ,"11110000"]
        ,[ 81 ,"Q"  ,"q"                  ,[[1,1,1,0],[1,1,0,0]] ,"11111000"]
        ,[ 82 ,"R"  ,"r"                  ,[[1,1,1,0],[0,1,0,0]] ,"11101000"]
        ,[ 83 ,"S"  ,"s"                  ,[[0,1,1,0],[1,0,0,0]] ,"01110000"]
        ,[ 84 ,"T"  ,"t"                  ,[[0,1,1,0],[1,1,0,0]] ,"01111000"]
        ,[ 85 ,"U"  ,"u"                  ,[[1,0,1,0],[0,0,1,0]] ,"10100100"]
        ,[ 86 ,"V"  ,"v"                  ,[[1,1,1,0],[0,0,1,0]] ,"11100100"]
        ,[ 87 ,"W"  ,"w"                  ,[[0,1,0,0],[1,1,1,0]] ,"01011100"]
        ,[ 88 ,"X"  ,"x"                  ,[[1,0,1,0],[1,0,1,0]] ,"10110100"]
        ,[ 89 ,"Y"  ,"y"                  ,[[1,0,1,0],[1,1,1,0]] ,"10111100"]
        ,[ 90 ,"Z"  ,"z"                  ,[[1,0,1,0],[0,1,1,0]] ,"10101100"]
        ,[ 91 ,"["  ,"ow"                 ,[[0,1,0,0],[1,0,1,0]] ,"01010100"]
        ,[ 92 ,"\\" ,"ou"                 ,[[1,1,0,0],[0,1,1,0]] ,"11001100"]
        ,[ 93 ,"]"  ,"er"                 ,[[1,1,0,0],[1,1,1,0]] ,"11011100"]
        ,[ 94 ,"^"  ,"(currency prefix)"  ,[[0,0,0,0],[1,1,0,0]] ,"00011000"]
        ,[ 95 ,"_"  ,"(contraction)"      ,[[0,0,0,0],[1,1,1,0]] ,"00011100"]
        ,[ 96 ,""   ,""                   ,[[0,0,0,0],[0,0,0,0]] ,"00000000"]
        /* Lowercase has identical DotPattern to uppercase. */
        ,[ 97 ,"a"  ,"a"                  ,[[1,0,0,0],[0,0,0,0]] ,"10000000"]
        ,[ 98 ,"b"  ,"b"                  ,[[1,1,0,0],[0,0,0,0]] ,"11000000"]
        ,[ 99 ,"c"  ,"c"                  ,[[1,0,0,0],[1,0,0,0]] ,"10010000"]
        ,[100 ,"d"  ,"d"                  ,[[1,0,0,0],[1,1,0,0]] ,"10011000"]
        ,[101 ,"e"  ,"e"                  ,[[1,0,0,0],[0,1,0,0]] ,"10001000"]
        ,[102 ,"f"  ,"f"                  ,[[1,1,0,0],[1,0,0,0]] ,"11010000"]
        ,[103 ,"g"  ,"g"                  ,[[1,1,0,0],[1,1,0,0]] ,"11011000"]
        ,[104 ,"h"  ,"h"                  ,[[1,1,0,0],[0,1,0,0]] ,"11001000"]
        ,[105 ,"i"  ,"i"                  ,[[0,1,0,0],[1,0,0,0]] ,"01010000"]
        ,[106 ,"j"  ,"j"                  ,[[0,1,0,0],[1,1,0,0]] ,"01011000"]
        ,[107 ,"k"  ,"k"                  ,[[1,0,1,0],[0,0,0,0]] ,"10100000"]
        ,[108 ,"l"  ,"l"                  ,[[1,1,1,0],[0,0,0,0]] ,"11100000"]
        ,[109 ,"m"  ,"m"                  ,[[1,0,1,0],[1,0,0,0]] ,"10110000"]
        ,[110 ,"n"  ,"n"                  ,[[1,0,1,0],[1,1,0,0]] ,"10111000"]
        ,[111 ,"o"  ,"o"                  ,[[1,0,1,0],[0,1,0,0]] ,"10101000"]
        ,[112 ,"p"  ,"p"                  ,[[1,1,1,0],[1,0,0,0]] ,"11110000"]
        ,[113 ,"q"  ,"q"                  ,[[1,1,1,0],[1,1,0,0]] ,"11111000"]
        ,[114 ,"r"  ,"r"                  ,[[1,1,1,0],[0,1,0,0]] ,"11101000"]
        ,[115 ,"s"  ,"s"                  ,[[0,1,1,0],[1,0,0,0]] ,"01110000"]
        ,[116 ,"t"  ,"t"                  ,[[0,1,1,0],[1,1,0,0]] ,"01111000"]
        ,[117 ,"u"  ,"u"                  ,[[1,0,1,0],[0,0,1,0]] ,"10100100"]
        ,[118 ,"v"  ,"v"                  ,[[1,1,1,0],[0,0,1,0]] ,"11100100"]
        ,[119 ,"w"  ,"w"                  ,[[0,1,0,0],[1,1,1,0]] ,"01011100"]
        ,[120 ,"x"  ,"x"                  ,[[1,0,1,0],[1,0,1,0]] ,"10110100"]
        ,[121 ,"y"  ,"y"                  ,[[1,0,1,0],[1,1,1,0]] ,"10111100"]
        ,[122 ,"z"  ,"z"                  ,[[1,0,1,0],[0,1,1,0]] ,"10101100"]
    ]
;
