/*
  Debug() is like Echo() but--without a *Boolean*--it is only ever *$Debug* sensitive.
  Debug() returns *Value* (defaults to 0) and can be used in any expression without changing the result, providing an appropriate *Value* is chosen.

  |  Bar=12;
  |  Foo=Bar*3+Debug(["Bar = ",Bar]);
  |  echo(Foo);
  ~  ECHO: "DEBUG: Bar = 12"
  ~  ECHO: 36

  Alternatively, simply use it in a 'let()' statement.

  |  let(
  |     Bar=12,
  |     Foo=Debug([Bar])
  |  )
  ~  ECHO: "DEBUG: 12"
*/
function Debug(StringsTuple=[],Value=0)=
    $Debug
    /* Now we have to do stupid stuff to make text stand out in the console. RIP html rendering, died 2021.01. */
    ?   echo(TupleToString(concat(["###### DEBUG #####: "],StringsTuple)))Value
    :   Value
;

/* For stand-alone ability... */
module Debug(StringsTuple=[]){
    Foo=Debug(StringsTuple);
}
