/*
  FallBack() returns 'TrueValue' if Test=true and 'FallBackValue' if Test=false.

  FallBack() is Boolean sensitive, by default and for simplicity, set to $Verbose. Only when FallbackValue is used and Boolean is true, *StringsTuple* will be printed to the console.

  These two examples achieve the same:

  |  Foo=Bar*FallBack(Bar<10,10,100,["Fallback used for Foo."]);

  |  Foo=Bar<10
  |  ?   Bar*10
  |  :   Bar*100+Echo(["Fallback used for Foo."]); // Echo returns '0'
*/
function FallBack(Test,TrueValue,FalseValue,StringsTuple=[],Boolean=$Verbose)=
    Test
    ?   TrueValue
    :   Boolean
        ?   echo(TupleToString(
                StringsTuple==[]
                /* Now we have to do stupid stuff to make text stand out in the console. RIP html rendering, died 2021.01. */
                ?   ["###### FALLBACK: ",FalseValue," was used instead of ",TrueValue,"."]
                :   concat(["###### FALLBACK: "],StringsTuple)
            ))FalseValue
        :   FalseValue
;
