/*
  <GHOUL/Lib/Lib_All.scad>

  Hank J. van Leuvensteijn Jr. 2021
  hankjr@hankjr.ca

  The GHOUL (Great Helpful OpenSCAD Unified Library) is set free under the unlicense:

  Anyone is free to copy, modify, publish, include, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.
*/

/*
  All of the GHOUL in one fell swoop. Everything but the sink.
  This file is include<>d by <GHOUL/Config.scad> to make the entire library available at all times, let's face it, we're not running this on a Commodore 64.

  If you prefer to load libraries individually and figure out dependencies, that's up to you.
*/

/*
  Definitions of units, colors, constants &c. go first and not alphabetically like the rest of the libraries, so they are available to the other libraries at compile time.
*/
include<Lib_Definitions.scad>

include<Lib_Animation.scad>
include<Lib_Arrays.scad>
include<Lib_Bezier.scad>
include<Lib_Curves.scad>
include<Lib_Echos.scad>
include<Lib_MathAndLogic.scad>
include<Lib_Matrices.scad>
include<Lib_Meshes.scad>
include<Lib_Modifiers.scad>
include<Lib_Objects.scad>
include<Lib_Parts.scad>
include<Lib_Shapes.scad>
include<Lib_Strings.scad>
include<Lib_SVG.scad>
include<Lib_SVG_Fonts.scad>
include<Lib_SVG_Shapes.scad>
include<Lib_Texts.scad>
include<Lib_Tuples.scad>
include<Lib_Vectors.scad>
include<Lib_Visualisers.scad>
