/*
  <GHOUL/Lib/Lib_Echos.scad>

  Hank J. van Leuvensteijn Jr. 2021
  hankjr@hankjr.ca

  The GHOUL (Great Helpful OpenSCAD Unified Library) is set free under the unlicense:

  Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.
*/

/*
  Various echo()-related functions and modules; Debug() is $Debug sensitive and Echo() is subject to $Verbose (no output unless $Verbose =true), Alert() and Print() have a Boolean parameter for output (Defaults to "true").

  The function calls return a value and can thus be used as part of an
  expression. The returned value depends on the function flavour, some
  return in-context values for debugging purposes, others return a fixed value
  of '0', just to enable the 'in-expression-call' functionality.

  The module calls are used outside of expression context for a simple call.
*/

include<Echos/Alert.scad>
include<Echos/Debug.scad>
include<Echos/Echo.scad>
include<Echos/ErrorOnFalse.scad>
include<Echos/ErrorOnTrue.scad>
include<Echos/FallBack.scad>
include<Echos/Print.scad>
include<Echos/Stop.scad>
