/*

  <GHOUL/Lib/Lib_Shapes.scad>

  Hank J. van Leuvensteijn Jr. 2021
  hankjr@hankjr.ca

  The GHOUL (Great Helpful OpenSCAD Unified Library) is set free under the unlicense:

  Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.

    TODO
    * Define using SVG
    * ALL polygons to be [[points][faces]] REGARDLESS
    * EVERYTHING CENTERED!!!!!!!!!!!!!!!!!!!!!!!!!
    *
    * ** give all default centered but give flag for 1st quadrant
    * I-beam with internal radii
    * T and Right angled profiles with internal radius, equal and unequal etc.
    * regular star
    * signature
    * name
    * logo
    * nuts, $fn 6 circle intersected with high $fn circle to chamfer corners
    * radiused cube, FN=4 gives chamfered?
    * radiused triangle
    * chamfered triangle
    * chamfered others?
    * radiused cube
    * radiused bar
    * radiused cylinder (hull of two spheres?)
    * cones
    * any old fancy rotational or extrudeable shape <<<<<<<<<<<<<<<<<<
    * domed caps for tubulars
    * pyramids, eggs
    * VANES - turbine, fanblades
    * TUBIFY all tubifiable shapes ;-)
    * rotated cross section caps as well as flat radiused caps for all shapes.
    * TODO chamfer other shapes, use Offset and LPerpVector?
    * Barrel or puck shapes
**/

// 2D and 3D vertex clouds and linear_extrude-able polygon shapes ==============
/*
  Shape functions always return an array of points AND faces.

  NOTE: For consistency in this library 'faces' is always generated, even if
        it's trivial as it is in simple closed polygons and similar cases.

  The module of the same name as the function draws a polygon that can be
  (rotate or linear) extruded into a 3D object.
*/

/*
  To provide consistency and avoid confusion, tubular bodies have 'Height'
  for their z-dimension in accordance with OpenSCAD conventions.

  The nomenclature here is as follows:
  * X-dimension : Width
  * Y-dimension : Length
  * Z-dimension : Height

  2D Polygons have their 'up' direction on the positive Y-axis.
*/

include<Shapes/ChamferedRectangle.scad>
include<Shapes/Diamond.scad>
include<Shapes/Ellipse.scad>
include<Shapes/EquilateralTriangle.scad>
include<Shapes/Grooved.scad>
include<Shapes/InsideRadius.scad>
include<Shapes/NGon.scad>
include<Shapes/OutsideRadius.scad>
include<Shapes/OvalRing.scad>
include<Shapes/PathsToPolygon.scad>
include<Shapes/RadiusedRectangle.scad>
include<Shapes/RectangularProfile.scad>
include<Shapes/RightTriangle.scad>
include<Shapes/Ring.scad>
include<Shapes/Sector.scad>
include<Shapes/Square.scad>
include<Shapes/Star.scad>

