/*
  <GHOUL/Lib/Lib_Vectors.scad>

  Hank J. van Leuvensteijn Jr. 2021
  hankjr@hankjr.ca

  The GHOUL (Great Helpful OpenSCAD Unified Library) is set free under the unlicense:

  Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.
*/

/**
    Vectors of equal dimension can be multiplied, divided, added and subtracted.

    [4,4] - [3,3]     => [1,1]
    [2, 4] + [1, 3]   => [3, 7]
    [2, 4] * [1, 3]   => 14       (Dot product)
    [4, 5] / 2        => [2, 2.5]
    [4,8] * 2         => [8,16]
**/

include<Vectors/Bisect.scad>
include<Vectors/CrossProduct.scad>
include<Vectors/Distance.scad>
include<Vectors/DotProduct.scad>
include<Vectors/EndDirection.scad>
include<Vectors/ExtendVector.scad>
include<Vectors/HomogeniseVector.scad>
include<Vectors/LPerpVector.scad>
include<Vectors/Modulus.scad>
include<Vectors/StartDirection.scad>
include<Vectors/SegmentDirection.scad>
include<Vectors/Offset.scad>
include<Vectors/PolarToVector.scad>
include<Vectors/ProjectVector.scad>
include<Vectors/RPerpVector.scad>
include<Vectors/LengthVector.scad>
include<Vectors/UnitVector.scad>
include<Vectors/VectorAngle.scad>
include<Vectors/VectorProject.scad>
include<Vectors/VectorToIncAz.scad>
include<Vectors/VectorToPolar.scad>
