/*
    Get the 'K' binomial coefficient from the 'N' row of Pascal's triangle.
*/
function BinomialCoefficient(N,K)=
    /*
      Save some time:  We're approaching K from one end of the row. The row is center-symmetric (BinomialCoefficient(N,K)=BinomialCoefficient(N,N-K)), so use min(K,N-K).
    */
    _BinomialCoefficient(N,min(K,N-K))
;

function _BinomialCoefficient(N,K,I=0,Result=1)=
    I==K
    ?   Result
    :   _BinomialCoefficient(N,K,I+1,Result*(N-I)/(I+1))
;

//------------------------------------------------------------------------------

/*
    Get the 'N' row of Pascal's triangle.
*/
function BiCoRow(N)=
    let(
        Fracs=
            [   1,
               for(Idex=[1:N]) (N+1-Idex)/Idex
            ]
    )
    _BiCoRow(Fracs,1,N)
;

function _BiCoRow(Fracs,Idex,N,Result=[1])=
    Idex==N
    ?   concat(Result,[1])
    :   _BiCoRow(Fracs,Idex+1,N,concat(Result,Fracs[Idex]*Result[Idex-1]))
;


