/*
  Based on Zeller's congruence.

  https://en.wikipedia.org/wiki/Zeller%27s_congruence

  1 <= m <= 12,  y > 1752 (in the U.K.).

  Returns: Sunday=0, Monday=1, ...

  * Use WeekDays[DayOfTheWeek(Year,Month,Day)] for string output e.g. "Sunday".
*/
function DayOfTheWeek(Year,Month,Day)=
    let(
        _Year=(Year-(Month<3?1:0)+(Year<100?2000:0)),
        M=Month+(Month<3?12:0),
        C=floor(_Year/100),
        Y=_Year%100
    )
    (
        Day
        +floor(13*(M+1)/5)
        +Y
        +floor(Y/4)
        +floor(C/4)
        +5*C // So far, 0=Saturday.
        +6 // To get 0 = Sunday; The GHOUL's *Weekdays* is [Sunday,...].
    )%7
;
/*
  Julian dates are simply a continuous count of days and fractions since noon Universal Time on January 1, 4713 BC (on the Julian calendar). Almost 2.5 million days have transpired since this date. Julian dates are widely used as time variables within astronomical software. *
*/
/*
  TODO: Not too sure about this routine. Check. And what's the *G* thingy about?
*/
function JulianDayOfTheWeek(Year,Month,Day,Hour=12,Julian=false)=
    let(
        _Year=(Year-(Month<3?1:0)+(Year<100?2000:0)),
        M=Month+(Month<3?12:0),
        C=floor(_Year/100),
        Y=_Year%100
    )
    (
        Day
        +floor(13*(M+1)/5)
        +Y
        +floor(Y/4)
        +5
        +6*C // So far, 0=Saturday.
        +6 // To get 0 = Sunday; The GHOUL's *Weekdays* is [Sunday,...].
    )%7
;
