/*
  Calculate a factorial.
*/
function Factorial(Int)=
    Int<0
    ?   undef
    :   _Factorial(Int,1)
;

function _Factorial(Int,Result)=
    Int<2
    ?   Result
    :   _Factorial(Int-1,Int*Result)
;

/*
  Sadly, this more elegant version is 15% slower on 1e5 operations of Factorial(100). Reason? Not tail-recursive.
  https://en.wikibooks.org/wiki/OpenSCAD_User_Manual/User-Defined_Functions_and_Modules#Recursive_functions
*/
function NOT_Factorial(Int)=
    Int<2
    ?   1
    :   NOT_Factorial(Int-1)*Int
;
