/*
  Greatest common divisor of an array of values or a value pair.
*/
function GreatestCommonDivisor(Value1,Value2)=
    let(
        Lth=Len(Value1)
    )
    Lth==undef
    /* A value pair. */
    ?   Value2==0
        ?   Value1
        :   GreatestCommonDivisor(Value2,Value1%Value2)
    /* An array, knock it down one pair at a time. */
    :   Lth>1
        /* At least three values left. */
        ?   GreatestCommonDivisor([
                GreatestCommonDivisor(Value1[1],Value1[0]),
                for(I=[2:Lth])
                    Value1[I]
            ])
        /* We're down to a value pair. */
        :   Value1[1]==0
            ?   Value1[0]
            :   GreatestCommonDivisor(Value1[1],Value1[0]%Value1[1])
;

/* If you'd rather not have 21-letter function names in your code... */
function GCD(Value1,Value2)=
    GreatestCommonDivisor(Value1,Value2)
;
