/*
  Uses 'HexCharLow' so '3a6f' as well as '3A6F' are acceptable, initial "#" is scrubbed.
*/
function HexToDec(Hex)=
    let(
        /* Scrub initial "#". */
        _Hex=Hex[0]=="#"?RightString(Hex,1):Hex,
        /* Turn Hex into array of values 0-15. */
        HexVals=MapString(str(_Hex),HexValues,HexCharLow),
        End=Len(HexVals)
    )
    ArraySum(
        /* sum values in the array. */
        [
            /* multiply values in array with 16 to the power of their index. */
            for(Idex=[0:End])
                HexVals[End-Idex]*pow(16,Idex)
        ]
    )
;
