// Turn decimal inch dimension into fractional.

Inch64ths=["","1/64","1/32","3/64","1/16","5/64","3/32","7/64","1/8","9/64","5/32","11/64","3/16","13/64","7/32","15/64","1/4","17/64","9/32","19/64","5/16","21/64","11/32","23/64","3/8","25/64","13/32","27/64","7/16","29/64","15/32","31/64","1/2","33/64","17/32","35/64","9/16","37/64","19/32","39/64","5/8","41/64","21/32","43/64","11/16","45/64","23/32","47/64","3/4","49/64","10/32","51/64","13/16","53/64","27/32","55/64","7/8","57/64","29/32","59/64","15/16","61/64","31/32","63/64",""];

function InchFraction(Value,Res=16)=
let(
    /* Find how many *Res* parts the fraction is. */
    Frac=round(Res*(Value%1)),
    /* Grab the correct string. */
    Str= Inch64ths[Frac*64/Res]
)
    /* If the fraction is zero or less than half of resolution, we simply round down... */
    Frac==0
    ?   str(Value)
        /* If the fraction is less than half of resolution from 1, we round up... */
    :   Frac==Res
        ?   str(floor(Value)+1)
        /* We have a proper fraction. */
        :   str(floor(Value),"-",Str)
;
