/*
  Call with ONLY one defined coordinate in the third point:
  Foo=InlineVertex([0,0,0],[5,2,1],[undef,4,undef]);
  Returns the third point: [10,4,2]
*/
function InlineVertex(Vertex1,Vertex2,Coordinate)=
    let(
        Idex=FindNE(undef,Coordinate),
        Vector=Vertex2-Vertex1
    )
    /* return the complete vertex. */
    Vector[Idex]==0
    ?   Echo(["Vertices are parallel to plane ",["X","Y","Z"][Idex],"=0."],Value=undef)
    :   Vertex1+(Coordinate[Idex]-Vertex1[Idex])/Vector[Idex]*Vector
;
