/*
  Generate the intermediate of *Start* and *End* at a fraction *Frac* of the distance from *Start*.
  *Start* and *End* can be a value, a tuple or an array of tuples, vectors &c. Any 'depth' of array will be processed. Also works for TheGHOUL colors.

  echo(Intermediate(RED,BLU,0.5));
  ECHO: "#7F007F"

  *Dec* is an afterthought here; I needed to show an array in the preview, for an animated image, and all those decimals were making it messy, I left it in, but I don't really see another application for it. You could process a multi-level array of scalars *Array* with Decimals() by doing this, if that's ever anything you need...

  Intermediate(Array,Array,1,3) // Reduce every scalar in *Array*
                                // to 3 decimals max.

*/
function Intermediate(Start,End,Frac,Dec=undef)=
    let(
        /* Make sure lists (vectors, arrays &c.) are of the same length. */
        LenS=Len(Start),
        Lth=LenS!=Len(End)
        ?   Stop(["Values have different lengths in Intermediate.scad."])
        :   LenS
    )
    Lth==undef
    /* We're looking at scalars; get it done. */
    ?   _Intermediate(Start,End,Frac,Dec)
    /* Special case: colors. */
    :   Lth==6&&Start[0]=="#"
        /* The GHOUL Hex Color (like DSG &c. See TheGHOUL/Lib/Defenitions/Colors.scad) */
        ?   ColorTupleToHex(
                _Intermediate(
                    ColorHexToTuple(Start),
                    ColorHexToTuple(End),
                Frac,undef)
            )
        /* Some list of numbers, vertices or vectors &c. (hopefully) Anything indexable that's not a color will end up here, so, there's some considerable room for FAFO.*/
        :   [
                for(Idex=[0:Lth])
                _Intermediate(Start[Idex],End[Idex],Frac,Dec)
            ]
;

function _Intermediate(Start,End,Frac,Dec)=
    is_num(Start)
    ?   Dec==undef
        /* Raw data is fine. */
        ?   Start+Frac*(End-Start)
        /* Limit decimals in the output. */
        :   Decimals(Start+Frac*(End-Start),Dec)
    /* We've been fed a list; dig down (again)... */
    :   Intermediate(Start,End,Frac)
;
