/*
  Interpolate returns value from 'Range' proportionally equivalent to the position of 'Value' on 'Domain'.
  * If 'Value' lies outside 'Domain', the result will be extrapolated.
  Domain, Range: tuples, range expressed as [Min,Max]
  Value: decimal.
*/
function Interpolate(Domain,Range,Value)=
    (Value-Domain.x)/(Domain.y-Domain.x)*(Range.y-Range.x)+Range.x
;
