/*
  Least common multiple of an array of values.
*/
function LeastCommonMultiple(Value1,Value2)=
    let(
        Lth=Len(Value1)
    )
        Lth==undef
        /* A value pair. */
        ?   Value1*Value2/GreatestCommonDivisor(Value1,Value2)
        /* An array, knock it down one pair at a time. */
        :   Lth>1
            /* At least three values left. */
            ?   LeastCommonMultiple([
                    LeastCommonMultiple(Value1[1],Value1[0]),
                    for(I=[2:Lth])
                        Value1[I]
                ])
            /* We're down to a value pair. */
            :   LeastCommonMultiple(Value1[1],Value1[0])
;

/*
  I don't like abbreviations, but I think few would argue that this doesn't make sense.
*/
function LCM(Value1,Value2)=
    LeastCommonMultiple(Value1,Value2)
;
