/*
  Maps value onto [min...max).

  Circular map Value onto an interval so that Min maps onto the lower limit of the interval and the upper limit (non-inclusive) maps back onto the lower (circular map).

  Map() and Mod() are different in this sense:

  Mod360(-450)=-90
  Map360(-450)=270

  */
function Map(Value,Min,Max)=
    let(
        M=(Value-Min)%(Max-Min)
    )
    M+(M<0?Max:Min)
;

/*
  Map() shortcuts.
*/
// Hours, months
function Map12(Value)=
    Map(Value,0,12)
;
// Hours
function Map24(Value)=
    Map(Value,0,24)
;
// Minutes, Seconds
function Map60(Value)=
    Map(Value,0,60)
;
// Degrees
function Map360(Value)=
    Map(Value,0,360)
;
// Radians
function MapTau(Value)=
    Map(Value,0,Tau)
;
