/*
  Maps value onto [-modulo...(0)...modulo].

  Map() and Mod() are different in this sense:

  Mod360(-450)=-90
  Map360(-450)=270

  Modulo function equivalent to native % (modulo operator) HOWEVER, it returns the more useful _undef_ when *Modulo*=_0_ (Seriously, who needs NAN?).

  * ATTENTION: To be clear this, ONLY makes sense when your DIVISOR is a VARIABLE that has the potential of becoming 0, and the RESULT of the modulo operation (i.e., not the original value of the divisor) needs to be tested for that. If you can error trap the original 0-divisor, obviously you don't need this. Frankly, I don't know for sure why you wouldn't be able to go that route, but _just in case_, here is Mod().

  X%0 returns NAN since whatever 'improved' version... Yay. So nice to work with; unlike with 'undef', you can't test for 'nan', so no Y=XX==nan?true:false; constructs &c. SMFH. Again. Who writes this crap?

  Reduces Value by multiples of Modulo so
  Value>0 result 0<=Result<Modulo
  Value<0 result -Modulo<Result<=0
  Value : Any real number.
  Modulo: Any real number not 0, well, also 0, which will give you useful
          feedback in the form of 'undef' ;-).
*/
function Mod(Value,Modulo=1)=
    Modulo==0
    ?   undef
    :   Value%Modulo
;
