/*
  Returns the index of the most significant digit in a *fraction*.
*/
function MostSignificant(Value)=
    let(
        $TUP=StringToTuple(str(Value))
    )
    Value>=1
        ?   undef
        :   _FirstNonZero(Len($TUP),undef)
;

function _FirstNonZero(Index,Result)=
    let(
        STR=$TUP[Index]
    )
    Index<0
    ?   Result
    :   (STR!="0"&&STR!=".")
        ?   _FirstNonZero(Index-1,Index)
        :   _FirstNonZero(Index-1,Result)
;
