/*
  Optionally Clips a value, then nudges it off the limit in case it equals the limit.

  Used for avoiding 0 and 180 values for inclination angles that break viewport routines such as 'ScreenMove()'.

  'Thought' is a very small value. Almost nothing, well, not quite nothing; it's 1/4096 (2^12), so less than a second (You know; degree-minute-second.)
*/
function OffLimits(Value,Min,Max,Clip=true)=
    let(
        _Value=Clip
        ?   Clip(Value,Min,Max)
        :   Value
    )
    _Value==Min
    ?   Min+Thought
    :   _Value==Max
        ?   Max-Thought
        :   _Value
;
