/*
  What is says: Returns order of magnitude of a value...
*/
function OrderOfMagnitude(Value)=
    let(
    STR=str(Value)
    )
    /* Check for scientific notation, IsInArray() also works for characters in strings. */
    IsInArray("e",STR)
        /* That makes it easy... */
        ?   StringToDecimal(RightString(STR,-3))
        /* Check for fraction. */
        :   Value<1
            /* The location of the most significant digit (corrected for the decimal point) is the o.o.m. */
            ?-MostSignificant(Value)+1
            /* Number of digits before the decimal minus one. */
            :len(str(floor(Value)))-1
    ;
