/*
  An array [Start...End] in segments the size of *Step* (defaults to $fs). The first and last values in the array are ALWAYS *Start* and *End*.
  *Step* will be adjusted so that all steps are of one, equal size. If *Step* is negative, there will be abs(Step) steps (and thus *Steps*+1 values).
  * Sequence() is Stepped() with a start and end value.
*/
function Sequence(Start=0,End,Step=$fs)=
    let(
        Range=End-Start,
        Steps=Step>0
        ?   round(Range/Step)
        :   abs(Step)
    )
    [ for(Sdex=[0:Steps]) Start+Sdex/Steps*Range ]
;

