/*
  Like Position(), but with vertex-arrays.

  Affine-position a cloud (array) of vertices at a point, aligned to a direction specified by a vector.

  Vector:   Alignment vector (or subtraction of two points, i.e: a vector).
  Base:     Positioning point.
  Roll:     Additional rotation at the positioning point around the alignment vector.

  The +Z direction of the vertex-cloud will be aligned with the vector.
  The -X direction of the vertex-cloud's original orientation will become the apparent 'top'.

  AffinePosition uses VectorToIncaz(), its result may be surprising or counter-intuitive for vertex-clouds that are aligned with respectively the X or Y-axis; specify Alignment="X" or "Y" for more intuitive results.
*/
function AffinePosition(Array,Vector,Base=[0,0,0],Roll=0,Alignment="Z",Center=[0,0,0])=
    ArrayAdd(
        AffineRotate3D(Vector,
            ArrayAdd(
                AffineRotate3D(VectorToIncAz(Vector),
                    AffineRotate3D(
                        VectorToIncAz([
                            Alignment=="Y"?90:0
                            ,Alignment=="X"?-90:0
                            ,Alignment=="Y"?-90:0
                        ]),
                        ArrayAdd(
                            Array
                        ,-Center) // Translate array centre to origin.
                    ) // Apply 'orientation bias'.
                ) // Align with vector.
            ,Center) // Translate back on centre.
        ,Roll) // Roll around axis.
    ,Base) // Move to position.
;

