/*
  Perform affine transformation on an array of vertices.

  Vector:   An openSCAD scale() vector [x,y,z].
  List:     An array of vertices or a single vertex.
  Output2D: Force 2D output, even for 3D input, i.e., crop Z.

  Returns 3D or 2D consistent with input.
*/
function AffineScale(Vector,List,Output2D=false)=
    let(
        Matrix=ScalingMatrix(Vector)
    )
    undef==Len(List[0])
    // List is a vertex.
    ?   Len(List)==1||Output2D
        // 2D output.
        ?   CropTuple(ProjectVector(Matrix*HomogeniseVector(List)))
        // 3D output.
        :   PadTuple(ProjectVector(Matrix*HomogeniseVector(List)))
    // List is an array of vertices (we hope).
    :       Len(List[0])==1||Output2D
        // 2D output.
        ?   CropArray([ for(Vertex=List)
                    ProjectVector(Matrix*HomogeniseVector(Vertex))
                ])
        // 3D output.
        :   PadArray([ for(Vertex=List)
                ProjectVector(Matrix*HomogeniseVector(Vertex))
            ])
;
