/*
  Perform affine transformation on a vertex or an array of vertices.

  Matrix:   An affine transformation matrix.
  Array :   An array of vertices.
  Output2D: Force 2D output, even for 3D input arrays, i.e., crop Z.

  Returns 3D or 2D consistent with input.
*/
function AffineTransform(Matrix,List,Output2D=false)=
    undef==Len(List[0])
    // List is a vertex.
    ?   Len(List)==1||Output2D
        // 2D output.
        ?   CropTuple(ProjectVector(Matrix*HomogeniseVector(List)))
        // 3D output.
        :   PadTuple(ProjectVector(Matrix*HomogeniseVector(List)))
    // List is an array of vertices (we hope).
    :       Len(List[0])==1||Output2D
        // 2D output.
        ?   CropArray([ for(Vertex=List)
                    ProjectVector(Matrix*HomogeniseVector(Vertex))
                ])
        // 3D output.
        :   PadArray([ for(Vertex=List)
                ProjectVector(Matrix*HomogeniseVector(Vertex))
            ])
;
