/*
  Perform [affine] translation on (arrays of) vertices.

  List :    An array of vertices or a single vertex.
  Output2D: Force 2D output, even for 3D input arrays, i.e., crop Z.

  Returns 3D or 2D consistent with input.
*/
/*
  YES, it is nonsense to call this 'Affine', it's essentially just a vector sum, I could have used ArrayAdd() for the array, and a simple addition in the source code for a single vertex, but it's here for consistency.
*/
function AffineTranslate(Vector,List,Output2D=false)=
    undef==Len(List[0])
    // List is a vertex.
    ?   Len(List)==1||Output2D
        // 2D output.
        ?   CropTuple(List+Vector)
        // 3D output.
        :   PadTuple(List+Vector)
    // List is an array of vertices (we hope).
    :       Len(List[0])==1||Output2D
        // 2D output.
        ?   CropArray([ for(Vertex=List) Vertex+Vector ])
        // 3D output.
        :   PadArray([ for(Vertex=List) Vertex+Vector ])
;
