/*
    Affine shear matrix

    Shear is a movement in one direction, along another,
    e.g: a shear of 2Y per X means that the slice at X=2 moves 2x2=4 in the
    Y direction etc.

    The shear parameters are as follows:

    1  x/y x/z
    y/x  1 y/z
    z/x z/y  1

    Dependencies are column linked.
    Movement is row linked.

    Shear does funky things, the object becomes a flat plane when x/y=y/x etc.

    *   TODO this needs working out, maybe add some angle conversion routines...

    ShearingMatrix(Vector=[
                        [1,0,0],  -->  X movements over Y-axis and over Z-axis.
                        [0,1,0],  -->  Y movements over X-axis and over Z-axis.
                        [0,0,1],  -->  Z movements over X-axis and over Y-axis.
                    ]
            )

*/
function ShearingMatrix(Matrix=[[1,0,0],[0,1,0],[0,0,1]])=
    [
        concat(Matrix.x,0),
        concat(Matrix.y,0),
        concat(Matrix.z,0),
        [0,0,0,1]
    ]
;
