/*
    Generate a transformation matrix.

    Transforms: An array of transformations, formatted as three numbers plus
                one letter, "T", "S" or "R" for translate, scale, rotate e.g.

                [[0,0,10,"T"],[1,1,-1,"S"],[0,0,180,"R"]]

                The transformations are performed from left to right.
*/
 function TransformMatrix(Transforms=[],Result=IdentityMatrix(4),Index)=
    /* Initial call. */
    undef==Index
    /* Prime Index. */
    ?   TransformMatrix(Transforms,Result,len(Transforms)-1)
    :   0>Index
        /* We are done. */
        ?   Result
        /* Identify and apply the transform. */
        :   ("R"==Transforms[Index][3]||"r"==Transforms[Index][3])
            ?   TransformMatrix(Transforms,
                            Result*RotationMatrix(Transforms[Index]),
                            Index-1)
            :   ("T"==Transforms[Index][3]||"t"==Transforms[Index][3])
                ?   TransformMatrix(Transforms,
                                Result*TranslationMatrix(Transforms[Index]),
                                Index-1)
                :   ("S"==Transforms[Index][3]||"s"==Transforms[Index][3])
                    ?   TransformMatrix(Transforms,
                                    Result*ScalingMatrix(Transforms[Index]),
                                    Index-1)
                    /* Just because we _can_. */
                    :   ("SH"==Transforms[Index][3]||"sh"==Transforms[Index][3])
                        ?   TransformMatrix(Transforms,
                                        Result*ShearingMatrix(Transforms[Index]),
                                        Index-1)
                        /* We've been fed garbage. */
                        :   undef
;
