/*
  Face generating function.

    I had this written for quadrangular faces because the OpenSCAD manual says that's okay... However that resulted in a bunch more griping and moaning from CGAL about 'nonplanar' faces prompting it to start 'alternate construction' which apparently results in an ugly bunch of additional vertices and edges. Since it has to convert every quadrangle into triangles anyhow, I reverted back to defining my triangles explicitly so I don't have to put up with the moaning and griping from CGAL; also, I don't like how CGAL seems to switch diagonals unnecessarily and without any evident pattern from left to right in the quad-faces. RME...

  The space between two pairs of adjacent vertices on two adjacent polygons in 'forward' (low to high index) direction is filled with two triangles. This results in clockwise faces for 'clockwise' polygons, i.e. polygons, defined in Z=0, that have vertices arranged in a clockwise fashion. To put it differently: 'grab' the 'polyhedron-to-be' in your right hand so that the vertex order of the transecting polygons runs along your fingers towards your finger tips, if your thumb now points towards 'higher numbered' polygons, the faces will have their vertices arranged in clockwise fashion.;

  Starting at one vertex on a polygon, pair with the *next* vertex on the *same*
  polygon, then consider the space between these two vertices and the corresponding pair of vertices on the *previous* polygon along the polyhedron, and fill the space with two triangles.

  In the following example, the second 'quadspace' of the polyhedron is considered.

  There are 4 vertices per polygon (VPP) and we start with 'Polygon' = 1 so the first vertex of the polygon under consideration is 1x4=[4]. The second space starts with the second vertex so 'Vertex' = 1; the current vertex is thus 4+1=[5].

        v0p0 [0] *      * v0p1 [4]
                  \      \
                   \      \
           v1p0 [1] *------0 v1p1 [5] <= The current vertex.
                    |\     |
                    | \    |
                    |  \   |   See below in the function how the
                    |   \  |   faces [5,6,1] and [6,2,1] are generated.
                    |    \ |
                    |     \|
           v2p0 [2] *------* v2p1 [6]
                   /      /
                  /      /
        v3p0 [3] *      * v3p1 [7]
*/
function QuadSpace(Polygon,Vertex,VPP,NOV)=
    /* VPP='Vertices Per Polygon' NOV='(Total) Number Of Vertices' */
    [
        [                                             // QuadSpace(1,1,4,200)
            (Polygon*VPP +  Vertex             )%NOV, // = 4+1     => [5]
            (Polygon*VPP + (Vertex+1)%VPP      )%NOV, // = 4+2%4   => [6]
            (Polygon*VPP +  Vertex        - VPP)%NOV  // = 4+1-4   => [1]
        ],
        [
            (Polygon*VPP + (Vertex+1)%VPP      )%NOV, // = 4+2%4   => [6]
            (Polygon*VPP + (Vertex+1)%VPP - VPP)%NOV, // = 4+2%4-4 => [2]
            (Polygon*VPP +  Vertex        - VPP)%NOV  // = 4+1-4   => [1]
        ],
    ]
;
/* The quadrangle version. As above but as a quad instead of two triangles. See initial comments. */
function _QuadSpace(Polygon,Vertex,VPP,NOV)=
    /* VPP='Vertices Per Polygon' NOV='(Total) Number Of Vertices' */
    [
        [                                             // QuadSpace(1,1,4,200)
            (Polygon*VPP +  Vertex             )%NOV, // = 4+1     => [5]
            (Polygon*VPP + (Vertex+1)%VPP      )%NOV, // = 4+2%4   => [6]
            (Polygon*VPP + (Vertex+1)%VPP - VPP)%NOV, // = 4+2%4-4 => [2]
            (Polygon*VPP +  Vertex        - VPP)%NOV  // = 4+1-4   => [1]
        ],
    ]
;

