/*
  Copy children() into a circular array.
  Radius:         Radius of the array.
  IncludedAngle:  Angle the copies are divided over, the _total_ angle, i.e.,
                  4 objects with 30 degrees between each pair gives 'IncludedAngle'=90.
  Number:         Number of objects (total).
  Static:         If true, all copies face the same way as the original.
*/
module CircularArray(Radius=30,IncludedAngle=90,Number=4,Start=0,Static=false)
{
    let(
        /* Catch silly input. Animations! */
        Count=floor(Number-1),
        /* Catch 'nan' errors. */
        Step=Count<1
        ?   0
        :   IncludedAngle==360
            ?   IncludedAngle/Number
            :   IncludedAngle/Count
    )
    /* No negative numbers, obviously... */
    if(!(Count<0))
    for (Idex=[0:Count])
        rotate([0,0,Idex*Step+Start])
        translate([Radius,0,0])
        rotate([0,0,Static?-(Idex*Step+Start):0])
        children();
}
