/*
  Generate a linear, rectangular or 3D array of children().

  Spacing can be a vector of length 1, 2, or 3 or a single number, in which
  case it is expanded into a 3-vector.

  Number can be a vector of length 1, 2, or 3 or a single number, in which
  case it is expanded into a 3-vector with .y=.z=1.

  LinearArray(Spacing=[10,10,10],Number=[3,3,3]), a 3D array.
  LinearArray(Spacing=10,Number=[3,5]), an X-Y array.
  LinearArray(Spacing=10,Number=7), an X array.
*/
module LinearArray(Spacing=[0,0,0],Number=[1,1,1],Center=false)
{

    _Spacing=is_list(Spacing)
    ?   PadTuple(Spacing,Length=3,Padding=1)
    :   [Spacing,Spacing,Spacing];

    _Number=is_list(Number)
    ?   PadTuple(Number,Length=3,Padding=1)
    :   [Number,1,1];

    if(Center==true){
        translate([-_Number.x*_Spacing.x/2,
                   -_Number.y*_Spacing.y/2,
                   -_Number.z*_Spacing.z/2])
        for(Xdex=[1:_Number.x]){
            for(Ydex=[1:_Number.y]){
                for(Zdex=[1:_Number.z]){
                    translate([(Xdex-1)*_Spacing.x,(Ydex-1)*_Spacing.y,(Zdex-1)*_Spacing.z])
                    for (Idex = [0:$children-1]) children(Idex);
                }
            }
        }
    }
    else{
        for(Xdex=[1:_Number.x]){
            for(Ydex=[1:_Number.y]){
                for(Zdex=[1:_Number.z]){
                    translate([(Xdex-1)*_Spacing.x,(Ydex-1)*_Spacing.y,(Zdex-1)*_Spacing.z])
                    for (Idex = [0:$children-1]) children(Idex);
                }
            }
        }
    }
}
