/*
  Circles, and thus holes, in OpenSCAD are not round but actually $fn-agons
  that fit INSIDE the specified radius.

  Open GHOUL/DemoFiles/Img_OutRadius.scad in OpenSCAD for a visual explanation.

  To get a hole that has minimum dimensions of exactly the required radius,
  let's say 10, use a call like this:

  | circle(r=OutRadius(10));

  Since OutRadius() is called from _within_ the circle() call, it always gets the correct, local value of $fn, even if there is a $fn assignment inside the circle() call.

  OutRadius(r,Rate)
  r:      scalar; radius.
  TG:     flag; selects OpenSCAD or The GHOUL's method to determine the number
          of divisions of a circle. If you're looking for the first, set it to _false_. If you're looking for The GHOUL's more sensible method*, leave it _true_.

          * See comments at Segments().
*/
function OutRadius(r=1,TG=true)=
    let(
        Divisions=TG==true
        ?   Segments(r) // The GHOUL default.
        :   Fragments(r) // OpenSCAD default.
    )

    r*(1+(1/cos(180/Divisions)-1))
;
