/*
  Position an object at a point, aligned to a direction specified by a vector.

  Vector:   Alignment vector (or subtraction of two points, i.e: a vector).
  Base:     Positioning point.
  Roll:     Additional rotation at the positioning point around the alignment vector.

  The +Z direction of the object will be aligned with the vector.
  The -X direction of the object's original orientation will become the apparent 'top'.

  Position uses VectorToIncaz(), its result may be surprising or counter-intuitive for non-cylindrical objects, for objects that are aligned with respectively the X or Y-axis, specify Alignment="X" or "Y" for more intuitive results.
*/
module Position(Vector,Base=[0,0,0],Roll=0,Alignment="Z",Center=[0,0,0]){
    translate(Base)
    rotate(Roll,Vector)
    translate(Center)
    rotate(VectorToIncAz(Vector))
    rotate([
         Alignment=="Y"?90:0
        ,Alignment=="X"?-90:0
        ,Alignment=="Y"?-90:0
    ])
    translate(-Center)
    children();
}

