// Object that stays in the same location on the screen.
// (Requires regen...)
module ScreenPosition(Location=[0,0,0],SizeCompensation=40,ScreenFactor=40)
{
    // Compensate for viewport translation and rotation ($vpt and $vpr).
    translate($vpt)
    rotate($vpr)
    // Place on screen, compensated for distance ($vpd).
    translate(Location*$vpd/ScreenFactor)
    scale([1,1,1]*$vpd/SizeCompensation)
    children();
}
