/*
  The function returns the unit-base-vectors of a coordinate system (CS) that has a Z=0 plane that is parallel to the screen (the 'Screen' CS). The operator module translates children() by the coordinates of a vector of the object CS converted to the 'Screen' CS.

  Useful when animating an image, or when using $vpt, $vpr and $vpd to control the viewport; an object, e.g. some text can now be moved around the viewport easily, regardless of how the object coordinate system is oriented because ScreenMove() compensates automatically for the viewport parameters.

  Vector: interpreted as Screen() coordinates.

  * NOTE: When the positive Z-axis points below the 'horizon' drawn through the origin, 'left' becomes 'right'...
*/
function ScreenUCS(Size=1)=
    [
        AffineTransform(RotationMatrix($vpr),[Size,0,0]),
        AffineTransform(RotationMatrix($vpr),[0,Size,0]),
        AffineTransform(RotationMatrix($vpr),[0,0,Size])
    ]
;

module ScreenUCS(Size=1){
    UCS=ScreenUCS(Size);
    color(RED)
    Arrow(UCS.x);
    color(DGN)
    Arrow(UCS.y);
    color(BLU)
    Arrow(UCS.z);
}
