//  Tumble([720,360,540],$t)
//  Tumble([0,20*sin(360*$t),40*sin(360*$t)],1)
//  TumbleTuple, 'vector', 3 element array containing x,y, and z elements of the rotations, either simply angles like the first example, or sin() or cos() functions like the second example.
//  Factor, scalar, usually a fraction, or $t.
module Tumble(TumbleTuple=[720,360,1080],Factor=$t){
    rotate([
         Factor*TumbleTuple.x
        ,Factor*TumbleTuple.y
        ,Factor*TumbleTuple.z
    ])
    children();
}

module Wobble(WobbleTuple=[20,30,0],WobbleOffset=[0,0,0],WobbleFrequency=[1,1,1],Factor=$t){
    rotate([
         sin(Factor*360*WobbleFrequency.x)*WobbleTuple.x+WobbleOffset.x
        ,sin(Factor*360*WobbleFrequency.y)*WobbleTuple.y+WobbleOffset.y
        ,sin(Factor*360*WobbleFrequency.z)*WobbleTuple.z+WobbleOffset.z
    ])
    children();
}

