/*
  Draw an arrow to represent a vector.
    Vector: Vector or Real, in the latter case the vector becomes [Real,0,0].
    Base:   Vertex, base-point of the Vector.
    Points: Dimensions or fraction(s) of drawn arrow.
      * Points.y points 'forward'
      * Points.x points 'back'
      * Points.z if 'undef' Points values are absolute, if '!undef' Points
        values are interpreted as fractions of the vector's length.
    Thickness: Thickness of arrow shaft
*/
module Arrow(Vector,Points=[0,1],Thickness=0.5,Base=[0,0,0])
{
    _Vector=is_num(Vector)
    ?   [Vector,0,0]
    :   Vector;
    Length=Modulus(_Vector);
    /* If Points.z is NOT 'undef', treat 'Points' values as fractions of 'Length'. */
    Fr=undef==Points.z?1:Length;
    Position(Vector=_Vector,Center=[0,0,0],Base=Base)
    union(){
        /* Forward pointing head. */
        if(Points.y>0)
        translate([0,0,Length-Points.y*Fr])
        cylinder(r1=Thickness,r2=0,h=Points.y*Fr);
        /* Backward pointing head. */
        if(Points.x>0)
        cylinder(r1=0,r2=Thickness,h=Points.x*Fr);
        /* The shaft, if needed. */
        /* Ensure overlap with '0.9' factor. */
        if(Length>(Points.x+Points.y)*Fr)
        translate([0,0,Points.x*Fr*0.9])
        cylinder(r=Thickness/2,h=Length-(Points.x+Points.y)*Fr*0.9);
    }
}
