// An arcing arrow.
module ArrowArc(StartAngle,Angle,Radius,Thickness=0.1,Points=[0.3,0.3,1],Center=[0,0,0]){

    Length=Rad(Angle)*Radius;
    Fr=undef==Points.z?1:Length;
    XAngle=atan(Points.x*Fr/2/Radius);
    YAngle=atan(Points.y*Fr/2/Radius);
    /* 0.9 ensures overlap, see below. */
    ArcAngle=Angle-(XAngle+YAngle)*2*0.9;

    translate(Center)
    rotate(StartAngle)
    union(){
        if(Points.y>0)
        rotate([0,0,Angle-2*YAngle])
        translate([Radius,0,0])
        rotate([0,0,YAngle])
        rotate([-90,0,0])
        cylinder(r1=Thickness*1.5,r2=0,h=Points.y*Fr);

        if(Points.x>0)
        translate([Radius,0,0])
        rotate([0,0,XAngle])
        rotate([-90,0,0])
        cylinder(r1=0,r2=Thickness*1.5,h=Points.x*Fr);

        /* Ensure overlap with '0.9' factor. */
        rotate([0,0,XAngle*2*0.9])
        Arc(0,ArcAngle,Radius,Thickness);
    }


}
