/*
  A cylinder between two points with optional 'end-balls', choices are:
  * Begin   : A balled end at the begin point only.
  * End     : A balled end at the end point only.
  * Both    : A balled end at both points.
  * None is not an option, use 'CylinderBetween' instead ;-)
*/
module BallCylinderBetween(Point1,Point2,Radius=0.1,Ends="Both")
{
    $fn=Segments(Radius);
    // Because of the wonderfully wicked ways of the OpenSCAD gods, who decided that a sphere(), made under an $fn value that's (n*4) or (n*4)-1, should have no vertices in its equator plane--making the diameter of, arguably, its most important great circle undersize--we have to correct that rubbish here, so the terminating spheres are always the same size as the curve members. SMFH. Again...
    ORad=(2*ceil($fn/2))%4==0?OutRadius(Radius):Radius;
    Height=Modulus(Point2-Point1);
    Position(Point2-Point1,Point1)
    union(){
        cylinder(r=Radius,h=Height);
        if(Ends!="Begin")
        translate([0,0,Height])
        sphere(r=ORad);
        if(Ends!="End")
        sphere(r=ORad);
    }
}

