/*
  Generate a full year calendar.
*/
module YearCalendar(Year){

/* Placeholder. */

}

/*
  The basics are here... Customize it to your liking.

  Year: integer, two or four digits.
  Month: integer [1,12]
*/
/* 'SixWeeks' *not yet implemented*, it is intended for 'same size' output for a year calendar, to force equal row numbers regardless of month length and startday. */
module MonthCalendar(Year,Month,SixWeeks=false){

    TextSize=3;
    Prettify=[0,0,0];
    Thickness=0.1*TextSize;
    CellSize=[3,2];
    Shift=[0.5*TextSize,-1.5*TextSize,0];

    _Year=Year<100?Year+2000:Year;
    Days=MonthDays[Month-1]+(IsLeapYear(_Year)&&Month==2?1:0);
    DayOne=DayOfTheWeek(_Year,Month,1);
    Weeks=SixWeeks?6:ceil((DayOne+Days)/7);
    List=[for(Date=[-DayOne+1:Days])str(Date<1?"":Date)];

    /* Dates. */
    for(Wdex=[0:Weeks-1])
        for(Ddex=[0:6])
            translate(Shift)
            translate([Ddex*(TextSize*CellSize.x),Wdex*(-TextSize*CellSize.y),0])
            rotate(Prettify)
            linear_extrude(Thickness)
            text(text=List[7*Wdex+Ddex],size=TextSize);

    /* Month. */
    translate([Shift.x,0,0])
    translate([0,3*TextSize,0])
    text(text=str(Months[Month-1]," ",_Year),size=2*TextSize);

    /* Header. */
    for(Hdex=[0:6])
        translate([Shift.x,0,0])
        translate([Hdex*(TextSize*CellSize.x),0.5*TextSize,0])
        linear_extrude(Thickness)
        text(text=WeekDays3Char[Hdex],size=TextSize);

}
