/*
  Turn the positive-x side of any 'tubified', 'ring-like' or plane Shape into
  a rotate-extruded endcap.

  A 'Shape' is a Shape array (see Shapes), which is constructed like this: [[vertices],[faces]]
*/
module Cap(Shape){
    Dom=ArrayDomain(PadArray(Shape[0]));
    // Find the required 'Size' of cutting-cube for the 'Pos...' modules.
    Size=max(Dom[1].x-Dom[0].x,Dom[1].y-Dom[0].y,Dom[1].z-Dom[0].z)+Smidge;
    PosZ3D(Size) //Crop all that has -Z coordinates (lose the 'bottom').
    rotate([90,0,0])
    rotate_extrude()
    PosX2D(Size) // Crop all that has -X coordinates (lose the 'left side').
    polygon(Shape[0],Shape[1],10);
}
