
function ChamferedBar(Width,Length,Height,Chamfer=1,Centered=true)=
    let(
        Center=[Width,Length,Height]/2,
        Vertices=[
            [Chamfer,Chamfer,0],[Width-Chamfer,Chamfer,0],[Width-Chamfer,Length-Chamfer,0],[Chamfer,Length-Chamfer,0],
            [0,0,Chamfer],[Width,0,Chamfer],[Width,Length,Chamfer],[0,Length,Chamfer],
            [0,0,Height-Chamfer],[Width,0,Height-Chamfer],[Width,Length,Height-Chamfer],[0,Length,Height-Chamfer],
            [Chamfer,Chamfer,Height],[Width-Chamfer,Chamfer,Height],[Width-Chamfer,Length-Chamfer,Height],[Chamfer,Length-Chamfer,Height]
        ],
        Faces=[
            [0,1,2,3],
            [0,4,5,1],[1,5,6,2],[2,6,7,3],[3,7,4,0],
            [4,8,9,5],[5,9,10,6],[6,10,11,7],[7,11,8,4],
            [8,12,13,9],[9,13,14,10],[10,14,15,11],[11,15,12,8],
            [12,13,14,15]
        ],
        _Vertices=Centered
        ?   ArrayAdd(Vertices,-Center)
        :   Vertices
    )
    [_Vertices,Faces]
;
module ChamferedBar(Width,Length,Height,Chamfer=1,Centered=true){
    Foo=ChamferedBar(Width,Length,Height,Chamfer,Centered);
    polyhedron(Foo[0],Foo[1],2);
}
