// TODO selective chamfer: top, bottom, sides.
function ChamferedCube(Width,Length,Height,Chamfer=1,Centered=true)=
    let(
        Center=[Width,Length,Height]/2,
        Vertices=[
            [Width/2-Chamfer,Length/2-Chamfer,-Height/2],
                [-Width/2+Chamfer,Length/2-Chamfer,-Height/2],
                [-Width/2+Chamfer,-Length/2+Chamfer,-Height/2],
                [Width/2-Chamfer,-Length/2+Chamfer,-Height/2],
            [Width/2,Length/2-Chamfer,-Height/2+Chamfer],
                [Width/2-Chamfer,Length/2,-Height/2+Chamfer],
                [-Width/2+Chamfer,Length/2,-Height/2+Chamfer],
                [-Width/2,Length/2-Chamfer,-Height/2+Chamfer],
                [-Width/2,-Length/2+Chamfer,-Height/2+Chamfer],
                [-Width/2+Chamfer,-Length/2,-Height/2+Chamfer],
                [Width/2-Chamfer,-Length/2,-Height/2+Chamfer],
                [Width/2,-Length/2+Chamfer,-Height/2+Chamfer],
            [Width/2,Length/2-Chamfer,Height/2-Chamfer],
                [Width/2-Chamfer,Length/2,Height/2-Chamfer],
                [-Width/2+Chamfer,Length/2,Height/2-Chamfer],
                [-Width/2,Length/2-Chamfer,Height/2-Chamfer],
                [-Width/2,-Length/2+Chamfer,Height/2-Chamfer],
                [-Width/2+Chamfer,-Length/2,Height/2-Chamfer],
                [Width/2-Chamfer,-Length/2,Height/2-Chamfer],
                [Width/2,-Length/2+Chamfer,Height/2-Chamfer],
            [Width/2-Chamfer,Length/2-Chamfer,Height/2],
                [-Width/2+Chamfer,Length/2-Chamfer,Height/2],
                [-Width/2+Chamfer,-Length/2+Chamfer,Height/2],
                [Width/2-Chamfer,-Length/2+Chamfer,Height/2]
        ],
        Faces=[
            [0,1,2,3],
            [0,4,5],[0,5,6,1],[1,6,7],[1,7,8,2],[2,8,9],[2,9,10,3],[3,10,11],[3,11,4,0],
            [4,12,13,5],[5,13,14,6],[6,14,15,7],[7,15,16,8],[8,16,17,9],[9,17,18,10],[10,18,19,11],[11,19,12,4],
            [12,20,13],[13,20,21,14],[14,21,15],[15,21,22,16],[16,22,17],[17,22,23,18],[18,23,19],[19,23,20,12],
            [23,22,21,20]
        ],
        _Vertices=Centered
        ?   Vertices
        :   ArrayAdd(Vertices,Center)
    )
    [_Vertices,Faces]
;
module ChamferedCube(Width,Length,Height,Chamfer=1,Centered=true){
    Foo=ChamferedCube(Width,Length,Height,Chamfer,Centered);
    polyhedron(Foo[0],Foo[1],2);
}
