// TODO choice for one or two chamfered ends.
module ChamferedCylinder(Radius=10,Height=10,Chamfer=1,ChamferAngle=90,Centered=true){
    CAngle=ChamferAngle/2;
    Steps=Segments(Radius);
    Polygons=
        [
            [
                for (Step=[1:Steps])
                let(Angle=Step/Steps*360)
                [cos(Angle)*(Radius-Chamfer),sin(Angle)*(Radius-Chamfer),-Height/2]
            ],
            [
                for (Step=[1:Steps])
                let(Angle=Step/Steps*360)
                [cos(Angle)*Radius,sin(Angle)*Radius,Chamfer/tan(CAngle)-Height/2]
            ],
            [
                for (Step=[1:Steps])
                let(Angle=Step/Steps*360)
                [cos(Angle)*Radius,sin(Angle)*Radius,Height/2-Chamfer/tan(CAngle)]
            ],
            [
                for (Step=[1:Steps])
                let(Angle=Step/Steps*360)
                [cos(Angle)*(Radius-Chamfer),sin(Angle)*(Radius-Chamfer),Height/2]
            ]
        ];
    translate([0,0,Centered?0:Height/2])
    CoverMesh(Polygons,Endcaps=true,Convexity=2);
}
